/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.model.BakedModelProxy;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedRailSlopeBlock;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedRailSlopeModel
extends BakedModelProxy {
    private final BlockState slopeState;
    private final BlockState railState;
    private BakedModel slopeModel = null;
    private BakedModel railModel = null;

    public FramedRailSlopeModel(BlockState state, BakedModel baseModel) {
        super(baseModel);
        RailShape shape = (RailShape)state.m_61143_(PropertyHolder.ASCENDING_RAIL_SHAPE);
        Direction dir = FramedRailSlopeBlock.directionFromShape(shape);
        this.slopeState = (BlockState)((Block)FBContent.blockFramedSlope.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir);
        this.railState = (BlockState)Blocks.f_50156_.m_49966_().m_61124_((Property)BlockStateProperties.f_61403_, (Comparable)shape);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.getSlopeQuads(side, rand, extraData));
        RenderType layer = MinecraftForgeClient.getRenderType();
        if (layer == RenderType.m_110463_() || layer == null) {
            quads.addAll(this.getRailQuads(side, rand));
        }
        return quads;
    }

    @Override
    public List<BakedQuad> m_6840_(BlockState state, Direction side, Random rand) {
        return this.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    @Nonnull
    public IModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.getModelData();
        }
        return tileData;
    }

    public TextureAtlasSprite getParticleIcon(@Nonnull IModelData data) {
        return this.getSlopeModel().getParticleIcon(data);
    }

    @Override
    public TextureAtlasSprite m_6160_() {
        return this.getSlopeModel().m_6160_();
    }

    private BakedModel getSlopeModel() {
        if (this.slopeModel == null) {
            BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
            this.slopeModel = dispatcher.m_110910_(this.slopeState);
        }
        return this.slopeModel;
    }

    private List<BakedQuad> getSlopeQuads(@Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        return this.getSlopeModel().getQuads(this.slopeState, side, rand, extraData);
    }

    private List<BakedQuad> getRailQuads(@Nullable Direction side, Random rand) {
        if (this.railModel == null) {
            BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
            this.railModel = dispatcher.m_110910_(this.railState);
        }
        return this.railModel.getQuads(this.railState, side, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.blockFramedRailSlope.get()).m_49966_().m_61124_(PropertyHolder.ASCENDING_RAIL_SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
    }
}

